#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Font Forest 2Mod01.fsh  by ShnitzelKiller
//https://www.shadertoy.com/view/tddSWs
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Inspired by FabriceNeyret2's https://www.shadertoy.com/view/tdcXW2
// Original version: https://www.shadertoy.com/view/3stXDX

#define FDIST 0.5
#define MAXSTEP 100
#define TOL 0.001
#define MAXDIST 20.
#define INTERP_SCALE 0.3
#define REPEAT_SCALE 1.75
#define MOUSE_SCALE 0.014
#define TEXSCALE vec2(1.5, 1.)
#define TEX_BIAS 0.49803921568
#define VERT_SPEED 0.5
#define ROT_SPEED 0.25
#define OFFSET_SCALE 8.

// comment this to change to deterministic character order,
// or if you have weird artifacts where segments don't line up (on macbook GPUs)
#define SHUFFLE

float rand(vec2 uv) {
    return fract(814.*sin(uv.x*15829.+uv.y*874.));
}

float randoffset(vec2 uv) {
    vec2 id = floor((uv+REPEAT_SCALE*0.5)/REPEAT_SCALE);
    return rand(id);
}

float noise1D(float t) {
    return fract(14950.5*sin(1905.1*t));
}

vec2 id2coord(in float id) {
    #ifdef SHUFFLE
    id = floor(noise1D(id) * 256.);
    #endif
    return vec2(mod(id, 16.), floor(id/16.))/16.;
}

void transform(inout vec3 ro) {
    
    float offset = randoffset(ro.xy)*256.;
    ro = vec3(mod(ro.xy+REPEAT_SCALE*0.5, REPEAT_SCALE)-REPEAT_SCALE*0.5, ro.z/INTERP_SCALE + offset);
}

/**
Compute analytic gradient
*/
vec3 grad(in vec3 ro) {
    float realz = ro.z;
    float of = randoffset(ro.xy) * OFFSET_SCALE;
    transform(ro);
    float t = ro.z;
    float id = floor(t);
    vec2 offset = clamp(ro.xy+0.5, 0., 1.)/16.;
    vec2 coords1 = id2coord(id) + offset;
    vec2 coords2 = id2coord(id+1.) + offset;
    
    vec4 tex1 = textureGrad(texture0,coords1,dFdx(offset),dFdy(offset));
    vec4 tex2 = textureGrad(texture0,coords2,dFdx(offset),dFdy(offset));
    
    float dist1 = tex1.w-TEX_BIAS;
    float dist2 = tex2.w-TEX_BIAS;
    
    vec2 norm1 = (tex1.yz-TEX_BIAS)*2.;
    vec2 norm2 = (tex2.yz-TEX_BIAS)*2.;
    
    float tf = fract(t);
    float alpha = smoothstep(0., 1., tf);
    vec3 n = vec3(norm1 * (1.-alpha) + norm2 * alpha, (dist2 - dist1) * INTERP_SCALE * 6. * (tf - tf*tf));
    n.y = -n.y;
    return mix(normalize(n), vec3(0., 0., 1.), smoothstep(-INTERP_SCALE-TOL, -INTERP_SCALE, realz - iTime * VERT_SPEED + of));
}

float map(in vec3 ro) {
    float realz = ro.z;
    float of = randoffset(ro.xy) * OFFSET_SCALE;
    transform(ro);
    float t = ro.z;
    float id = floor(t);
    vec2 offset = clamp(ro.xy+0.5, 0., 1.)/16.;
    vec2 coords1 = id2coord(id) + offset;
    vec2 coords2 = id2coord(id+1.) + offset;
    
    float dist1 = textureGrad(texture0, coords1,dFdx(offset), dFdy(offset)).w-TEX_BIAS;
    float dist2 = textureGrad(texture0, coords2,dFdx(offset), dFdy(offset)).w-TEX_BIAS;
    vec2 displacement = abs(ro.xy)-0.5;
    float alpha = smoothstep(0., 1., fract(t));
    float d = max(max(displacement.x, displacement.y), 0.5*(dist1 * (1.-alpha) + dist2*alpha));
    return min(REPEAT_SCALE-1.,max(d, realz - iTime*VERT_SPEED + INTERP_SCALE + of));
}

vec2 raymarch(in vec3 eye, in vec3 rd) {
    float t = 0.0;
    int i;
    for (i=0; i<MAXSTEP; i++) {
        vec3 pos = eye + rd*t;
        float dist = map(pos);
        t += dist;
        if (abs(dist) < TOL || t > MAXDIST) break;
    }
    return vec2(t, i);
}

bool shadowmarch(in vec3 eye, in vec3 rd, float lightdist) {
    float t = 0.0;
    float minstep = 0.01;
    for (int i=0; i<50; i++) {
        vec3 pos = eye + rd * t;
        float dist = map(pos);
        if (dist < 0.) return true;
        else if (t > lightdist) return false;
        float s = max(dist, minstep);
        minstep += 0.001;
        t += s;
        
    }
    return false;
}

float shade(in vec3 n, in vec3 ro, in vec3 lightpos, bool shadow) {
    vec3 l = lightpos - ro;
    float ldist = length(l);
    if (shadow && shadowmarch(ro + n*TOL*2., l/ldist, ldist)) {
    	return 0.;
    }
    return max(0.,smoothstep(0., 1., dot(l, n)/ldist))*min(1., 1.5/(ldist));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord - 0.5 * iResolution.xy)/iResolution.xx;
	
    vec3 up = vec3(0, 0, 1);
    float rotfac = iTime*ROT_SPEED + iMouse.x*MOUSE_SCALE;
    vec3 eye = vec3(REPEAT_SCALE*0.6*cos(rotfac), REPEAT_SCALE*0.6*sin(rotfac), iTime*VERT_SPEED);
    vec3 lightpos = vec3(REPEAT_SCALE*0.5, REPEAT_SCALE*0.5, iTime*VERT_SPEED+0.5);
    vec3 lightpos2 = vec3(-REPEAT_SCALE*0.5, -REPEAT_SCALE*0.5, iTime*VERT_SPEED-0.5);
    vec3 w = normalize(vec3(-eye.xy, iMouse.y > 1. ? (iMouse.y-iResolution.y*0.7) * MOUSE_SCALE * REPEAT_SCALE * 0.33 : -0.5*cos(iTime*0.13)-0.5));
    vec3 u = normalize(cross(w, up));
    vec3 v = cross(u, w);
    vec3 rd = normalize(w*FDIST + u*uv.x + v*uv.y);
    
	vec2 t = raymarch(eye, rd);
    vec3 ro = t.x * rd + eye;
    vec3 n = grad(ro);
    
    float fac1 = shade(n, ro, lightpos, false);
    float fac2 = shade(n, ro, lightpos2, false);
    vec3 lighting = (fac1*vec3(0.7, 0.8, 1.) + fac2*vec3(0.7, 0.6, 0.6))*0.7;
    lighting += vec3(0.3)*smoothstep(0.2, 1., dot(-rd, n))*min(1., 0.5/(t.x*t.x));
    
    // --- glowing letters ---
    // X-ray glow
    float h = (fract(ro.z/INTERP_SCALE)-0.5)*INTERP_SCALE;
    float newt = INTERP_SCALE*0.5/abs(rd.z) - h/rd.z;
    vec3 roo = newt * rd + ro;
    float edgefac = (1.+sin(iTime*10.)*.2) * (sin((roo.x+roo.y + iTime*.1)*350.)*.5+.5) * smoothstep(0.005, 0., abs(map(roo)));
    
    // surface glow
    float alpha = smoothstep(0.85, 1., 2.*abs(fract(ro.z/INTERP_SCALE)-0.5));
    vec3 emissioncol =  vec3(0.5, 1., 0.7);
    float emissionfac = (alpha + edgefac) * min(1., 0.5/(t.x*t.x)) * min(0.75, (0.07/(newt)));
    
    // extrusion glow
    float of = randoffset(ro.xy) * OFFSET_SCALE;
    float shifted = ro.z - iTime * VERT_SPEED + of;
    float emissionfac2 = smoothstep(-INTERP_SCALE-0.02, -INTERP_SCALE, shifted);
    float emissionfac22 = 0.75*smoothstep(-INTERP_SCALE-0.05, -INTERP_SCALE, shifted);
    vec3 emission = emissionfac*emissioncol + emissionfac2*vec3(1., 0.6, 0.) + emissionfac22*vec3(1., 0.2, 0.);
    
    // --------------------
    
    // fog
    float fogfac = min(1.,t.x*0.05);
    vec3 fogcol = mix(vec3(1., 0.2, 0.0), 0.2*vec3(2, 3, 5), rd.z*.5+.5);
    
    vec3 finalcol = mix(lighting + emission, fogcol, fogfac);
    fragColor = vec4(pow(finalcol, vec3(0.75)),1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

